#include <ESP32Servo.h>

// ===== Potenciómetros =====
#define POT_RUDDER 32
#define POT_ELEV   35
#define POT_AIL    34

// ===== Servos =====
#define SERVO_RUDDER_PIN 13
#define SERVO_ELEV_L_PIN 12
#define SERVO_ELEV_R_PIN 14
#define SERVO_AIL_L_PIN  27
#define SERVO_AIL_R_PIN  26

Servo servoRudder;
Servo servoElevL;
Servo servoElevR;
Servo servoAilL;
Servo servoAilR;

int dead = 15;   // zona muerta para evitar temblores

// ---------- helper ----------
int applyDead(int v) {
  if (abs(v - 2048) < dead) return 2048;
  return v;
}

void setup() {
  Serial.begin(115200);

  analogReadResolution(12); // 0–4095

  servoRudder.attach(SERVO_RUDDER_PIN, 500, 2500);

  servoElevL.attach(SERVO_ELEV_L_PIN, 500, 2500);
  servoElevR.attach(SERVO_ELEV_R_PIN, 500, 2500);

  servoAilL.attach(SERVO_AIL_L_PIN, 500, 2500);
  servoAilR.attach(SERVO_AIL_R_PIN, 500, 2500);
}

void loop() {

  // ===== Leer potenciómetros =====
  int rudderRaw = applyDead(analogRead(POT_RUDDER));
  int elevRaw   = applyDead(analogRead(POT_ELEV));
  int ailRaw    = applyDead(analogRead(POT_AIL));

  // ===== Mapear a ángulos =====
  int rudderAng = map(rudderRaw, 0, 4095, 0, 180);
  int elevAng   = map(elevRaw,   0, 4095, 0, 180);
  int ailAng    = map(ailRaw,    0, 4095, 0, 180);

  // ===== Timón =====
  servoRudder.write(rudderAng);

  // ===== Elevadores (SIN espejo — mismo sentido) =====
  servoElevL.write(elevAng);
  servoElevR.write(elevAng);

  // ===== Alerones (EN ESPEJO) =====
  servoAilL.write(ailAng);
  servoAilR.write(180 - ailAng);

  // ===== Debug =====
  Serial.print("R:");
  Serial.print(rudderRaw);
  Serial.print(" E:");
  Serial.print(elevRaw);
  Serial.print(" A:");
  Serial.println(ailRaw);

  delay(60);
}
